---
generated_at: 2026-02-10 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-Visual Basicコンパイラ (vbc)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張がソースコードから確認可能

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Compilers/VisualBasic/vbc/Program.cs`
- E-02: `src/Compilers/VisualBasic/Portable/CommandLine/VisualBasicCompiler.vb`
- E-03: `src/Compilers/VisualBasic/Portable/CommandLine/VisualBasicCommandLineParser.vb`
- E-04: `src/Compilers/VisualBasic/Portable/CommandLine/VisualBasicCommandLineArguments.vb`
- E-05: `src/Compilers/Core/MSBuildTask/Vbc.cs`
- E-06: `src/Compilers/Core/Portable/CommandLine/CommonCompiler.cs`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | vbcはVBソースコードをILにコンパイルする | E-02 (CreateCompilation), E-07 | ○ |
| C-02 | エントリーポイントはProgram.Main | E-01 (16-29行目) | ○ |
| C-03 | RequestLanguage.VisualBasicCompileでリクエスト | E-01 (39行目), E-05 (42行目) | ○ |
| C-04 | ソースファイルを並列にパース可能 | E-02 (103-118行目 RoslynParallel.For使用) | ○ |
| C-05 | ResponseFileNameはvbc.rsp | E-02 (18行目) | ○ |
| C-06 | CommonCompilerを継承 | E-02 (15-16行目 Inherits CommonCompiler) | ○ |
| C-07 | OptionStrictオプション対応 | E-05 (133-137行目 OptionStrict) | ○ |
| C-08 | OptionExplicitオプション対応 | E-05 (127-131行目 OptionExplicit) | ○ |
| C-09 | OptionInferオプション対応 | E-05 (139-143行目 OptionInfer) | ○ |
| C-10 | OptionCompareオプション対応 | E-05 (121-125行目 OptionCompare) | ○ |
| C-11 | Importsオプション対応 | E-05 (86-90行目 Imports) | ○ |
| C-12 | NoVBRuntimeReferenceオプション対応 | E-05 (109-113行目) | ○ |
| C-13 | ManagedCompilerを継承 (MSBuildタスク) | E-05 (28行目 class Vbc : ManagedCompiler) | ○ |
| C-14 | VBエラーキューで診断メッセージ管理 | E-05 (36行目 _vbErrorLines) | ○ |
| C-15 | FileNotFoundExceptionをキャッチして終了 | E-01 (22-28行目) | ○ |
| C-16 | コンパイラサーバー経由での実行サポート | E-01 (33行目 CompilerServerLogger) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な機能記述
- 0: 低リスク - エントリーポイントと処理フローの記述
- 0: 低リスク - VB固有オプションの記述

## 6) レビュアーチェックリスト（最小）
- [ ] Program.csのエントリーポイント構造が正確か確認
- [ ] VisualBasicCompiler.vbのCreateCompilationの処理フローが正確か確認
- [ ] VB固有オプション (OptionStrict, OptionExplicit, OptionInfer) の一覧が最新か確認
- [ ] MSBuildタスク (Vbc.cs) のプロパティ一覧が網羅的か確認
